create or replace package body tbicds.PCK_QUESTIONNAIRES is
/* Copyright 2016 Intellica Corporation.  

This software is protected by FAR Subpart 27.4 - Rights in Data and Copyrights and 
international treaties.  The software was produced by Intellica Corporation of 
San Antonio, Texas for the Veterans Administration (VA) under Contract Number 
VA118-14-C-0015, Project Number TAC-16-28335 and Project Title, 
'Traumatic Brain Injury Clinical Decision Support (TBI CDS) Implementation'.  
Contract dates: 8 May 2014 - 4 January 2016.  This software was finalized 
and uploaded to the VA's Open Source Electronic Health Record Alliance (OSEHRA) 
on 31 December 2015.  Unauthorized reproduction or distribution of this software 
or any portion of it may result in severe civil and criminal penalties and will 
be prosecuted to the maximum possible extent of the law.

For licensing information contact:  info@intellicacorp.com 
*/
  /*Gets and returns a recordset from INTAKE_MODULE for the passed in module id.*/
  procedure GetModuleRS(pi_vSessionID       in varchar2,
                        pi_vSessionClientIP in varchar2,
                        pi_nUserID          in number,
                        pi_nMID             in number,
                        po_nStatusCode      out number,
                        po_vStatusComment   out varchar2,
                        rs                  out RetRefCursor) 
 is
  
    v_vSQL varchar2(32767) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' select * ';
    v_vSQL := v_vSQL || '   from intake_module t ';
    v_vSQL := v_vSQL || '  where t.active = 1 ';
    v_vSQL := v_vSQL || '    and t.mid = :MID ';
  
    open rs for v_vSQL
      using pi_nMID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

  /*Gets and returns a recordset from INTAKE_TOPIC for the passed in module id.*/
  procedure GetModuleTopicRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_nMID             in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor) 
 is
  
    v_vSQL varchar2(32767) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' select * ';
    v_vSQL := v_vSQL || '   from intake_topic t ';
    v_vSQL := v_vSQL || '  where t.active = 1 ';
    v_vSQL := v_vSQL || '    and t.mid = :MID ';
    v_vSQL := v_vSQL || '  order by t.tid';
  
    open rs for v_vSQL
      using pi_nMID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

  /*Gets and returns a recordset of questions from INTAKE_QUESTION
  for the passed in module id, topic id.*/
  procedure GetQuestionRS(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_nMID             in number,
                          pi_nTID             in number,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor) 
 is
  
    v_vSQL varchar2(32767) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' select * ';
    v_vSQL := v_vSQL || '   from intake_question t ';
    v_vSQL := v_vSQL || '  where t.active = 1 ';
    v_vSQL := v_vSQL || '    and t.mid = :MID ';
    v_vSQL := v_vSQL || '    and t.tid = :TID ';
    v_vSQL := v_vSQL || '  order by t.mid, t.tid, t.qid ';
  
    open rs for v_vSQL
      using pi_nMID, pi_nTID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

  /*Gets and returns a recordset of responses from INTAKE_RESPONSE
  for the passed in module id, topic id, question id.*/
  procedure GetResponseRS(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_nMID             in number,
                          pi_nTID             in number,
                          pi_nQID             in number,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor) 
 is
  
    v_vSQL varchar2(32767) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' select t.*, ';
    v_vSQL := v_vSQL || '        REGEXP_REPLACE(t.response, ''<.*?>'') as response_plain, ';
    v_vSQL := v_vSQL || '        REGEXP_REPLACE(REGEXP_REPLACE(t.response, ''<.*?>''), '','', ''**"**'') as response_checkbox ';
    v_vSQL := v_vSQL || '   from intake_response t ';
    v_vSQL := v_vSQL || '  where t.active = 1 ';
    v_vSQL := v_vSQL || '    and t.mid = :MID ';
    v_vSQL := v_vSQL || '    and t.tid = :TID ';
    v_vSQL := v_vSQL || '    and t.qid = :QID ';
    v_vSQL := v_vSQL || '  order by t.mid, t.tid, t.qid, t.rid ';
  
    open rs for v_vSQL
      using pi_nMID, pi_nTID, pi_nQID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

  /*Gets and returns a recordset of responses that have skip rules
  for the passed in module id.*/
  procedure GetSkipPatternRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_nMID             in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor) 
  is
  
    v_vSQL varchar2(32767) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' select t.* ';
    v_vSQL := v_vSQL || '   from INTAKE_RESPONSE t ';
    v_vSQL := v_vSQL || '  where t.mid = :MID ';
    v_vSQL := v_vSQL || '    and t.active = 1 ';
    v_vSQL := v_vSQL ||
              '    and (t.skip_show is not null or t.skip_hide is not null) ';
    v_vSQL := v_vSQL || '  order by t.rid ';
  
    open rs for v_vSQL
      using pi_nMID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

  /*Gets and returns a recordset of responses (textboxes) that have masks
  for the passed in module id.*/
  procedure GetMaskRS(pi_vSessionID       in varchar2,
                      pi_vSessionClientIP in varchar2,
                      pi_nUserID          in number,
                      pi_nMID             in number,
                      po_nStatusCode      out number,
                      po_vStatusComment   out varchar2,
                      rs                  out RetRefCursor) 
 is
  
    v_vSQL varchar2(32767) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' select t.* ';
    v_vSQL := v_vSQL || '   from INTAKE_RESPONSE t ';
    v_vSQL := v_vSQL || '  where t.mid = :MID ';
    v_vSQL := v_vSQL || '    and t.active = 1 ';
    v_vSQL := v_vSQL || '    and t.mask is not null ';
    v_vSQL := v_vSQL || '  order by t.rid ';
  
    open rs for v_vSQL
      using pi_nMID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

  /*Gets and returns a recordset from intake_static_data table to populate 
  responses of type combo*/
  procedure GetStatData(pi_vSessionID       in varchar2,
                        pi_vSessionClientIP in varchar2,
                        pi_nUserID          in number,
                        pi_nMID             in number,
                        pi_nTID             in number,
                        pi_nQID             in number,
                        pi_nRID             in number,
                        po_nStatusCode      out number,
                        po_vStatusComment   out varchar2,
                        rs                  out RetRefCursor) 
 is
  
    v_vSQL        varchar2(32767) := '';
    v_vSQL_FILTER varchar2(32767) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    begin
      select t.stat_load_filter
        into v_vSQL_FILTER
        from intake_response t
       where t.mid = pi_nMID
         and t.tid = pi_nTID
         and t.qid = pi_nQID
         and t.rid = pi_nRID;
    exception
      when others then
        v_vSQL_FILTER := '';
    end;
  
    v_vSQL := v_vSQL || ' select t.* ';
    v_vSQL := v_vSQL || '   from INTAKE_STATIC_DATA t ';
    v_vSQL := v_vSQL || '  where t.active = 1 ';
    v_vSQL := v_vSQL || '    and ';
    v_vSQL := v_vSQL || v_vSQL_FILTER;
  
    open rs for v_vSQL;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

  /*Get the next undone assigned module for the patient. */
  procedure GetNextModuleRS(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_vPatientID       in varchar2,
                          pi_vSiteID          in varchar2,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor) 
  is
  
    v_vSQL varchar2(32767) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' select * from (';
    v_vSQL := v_vSQL || ' select t.*, m.sort_order ';
    v_vSQL := v_vSQL || '   from patient_module t, intake_module_group_mid m ';
    v_vSQL := v_vSQL || '  where t.patient_id = :PATIENT_ID ';
    v_vSQL := v_vSQL || '    and t.status = 0 ';
    v_vSQL := v_vSQL || '    and t.mid = m.mid ';
    v_vSQL := v_vSQL || '    and t.module_group_id = m.module_group_id ';
    v_vSQL := v_vSQL || '  order by m.sort_order ';
    v_vSQL := v_vSQL || ' ) ';
    v_vSQL := v_vSQL || ' where ROWNUM < 2 ';
  
    open rs for v_vSQL
      using pi_vPatientID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;
  
  /* gets a new intake_id for the module */
  procedure GetNewIntakeID(pi_vSessionID       in varchar2,
                      pi_vSessionClientIP in varchar2,
                      pi_nUserID          in number,
                      po_nStatusCode      out number,
                      po_vStatusComment   out varchar2,
                      rs                  out RetRefCursor) 
 is
 
   v_seqintakeid number;
 
 begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    select seqintakeid.nextval into v_seqintakeid from dual;
  
    open rs for 
      select v_seqintakeid as intake_id from dual;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

end PCK_QUESTIONNAIRES;
/

